/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui.wavtocpc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javazoom.jl.converter.Converter;
import jemu.system.cpc.CPC;
import jemu.ui.JEMU;
import jemu.ui.Main;
import jemu.ui.wavtocpc.CheckDOS;
import jemu.ui.wavtocpc.SyntheticaLicense;
import jemu.ui.wavtocpc.Util;
import org.apache.commons.io.IOUtils;

public final class WAVtoCPC
extends JPanel {
    int bytechange = 13;
    protected SourceDataLine line;
    public final int[] CPCRate = new int[]{14, 12, 11, 8, 6, 5, 4};
    public final float[] SAMPLE_RATE = new float[]{13600.0f, 12000.0f, 11025.0f, 8000.0f, 6000.0f, 5513.0f, 4000.0f};
    protected final int[] seperation = new int[]{500, 400, 350, 250, 200, 150, 100};
    protected static AudioFormat STEREO_FORMAT;
    protected static AudioFormat MONO_FORMAT;
    int channels;
    int linepos = 0;
    boolean oldmono = false;
    String newname = "";
    byte[] play;
    boolean isPlaying = false;
    ActionListener update = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            WAVtoCPC.this.updateDisplay();
        }
    };
    Timer fireUpdate = new Timer(5, this.update);
    Color leftCol = new Color(0, 0, 0);
    Color rightCol = new Color(0, 0, 0);
    double lcd = 0.0;
    double rcd = 0.0;
    double lcdm;
    double rcdm;
    int ldelay;
    int rdelay;
    int lc;
    int rc;
    int step;
    int pos;
    int grapos;
    int posp = 0;
    int poshx;
    float samplemillis;
    float posmillis;
    int haquant;
    float haposy;
    boolean displayinit = false;
    private JLabel aPanel = new JLabel();
    private JLabel bPanel = new JLabel();
    BufferedImage aVu;
    BufferedImage bVu;
    private Graphics apanel;
    private Graphics bpanel;
    boolean fontset = false;
    int oldhagx = 900;
    int oldhagy = 60;
    Image pumpkin;
    Image hag;
    Image trantor;
    Image homebase;
    Image homesmoke;
    int trantorpos = -90;
    float secs;
    FileDialog dia;
    String filepath;
    String filename;
    boolean wasplaying;
    CheckDOS chkdos;
    boolean skip;
    boolean disabled;
    Converter converter;
    boolean isReading;
    boolean isMp3;
    private static final float ALPHA = 0.75f;
    byte[] buffer;
    BufferedImage display;
    BufferedImage ondisplay;
    int[] volumes1;
    int[] volumeTable;
    int[][] volumes;
    int[] volume;
    boolean inverted;
    boolean raw_sample;
    protected int[] compare;
    byte[] left;
    byte[] right;
    byte[] export;
    int nibbleLeft;
    int nibbleRight;
    FileDialog saveAs;
    protected byte[] SOURCEFILE;
    protected byte[] RESULT;
    protected byte[] HEADER;
    protected String internalname;
    protected int namepos;
    protected int filetypepos;
    protected int datalengthpos;
    protected int datalocationpos;
    protected int firstblockpos;
    protected int filelengthpos;
    protected int execaddresspos;
    protected int lengthpos;
    protected int checksumpos;
    int newlinepos;
    private JCheckBox asSample;
    private JSlider booster;
    private JCheckBox filter;
    private JCheckBox sendPlayCommand;
    private JButton jButton1;
    private JButton saveButton;
    private JButton jButton3;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JButton jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel VUMeter;
    private JCheckBox mono;
    private JCheckBox normalize;
    private JCheckBox seperate;
    private JComboBox<String> sfreq;
    private JCheckBox to14;
    private JComboBox<String> vol;
    private JSlider vol1;
    private JSlider vol10;
    private JSlider vol11;
    private JSlider vol12;
    private JSlider vol13;
    private JSlider vol14;
    private JSlider vol15;
    private JSlider vol16;
    private JSlider vol2;
    private JSlider vol3;
    private JSlider vol4;
    private JSlider vol5;
    private JSlider vol6;
    private JSlider vol7;
    private JSlider vol8;
    private JSlider vol9;
    private JSlider volumeSet;
    private CPC cpc;
    String tabtitle = "";
    boolean doWarn = false;
    boolean blinkWarn = false;
    int banks = 0;
    String basCode = "10 MEMORY &3FFF:MODE 1:INK 0,0:BORDER 0:INK 1,26:INK 2,26:INK 3,26\r\n20 LOAD\"CODE.BIN\",&8D00\r\n30 CALL &8D00:|frequency\r\n40 MOVE left,198:DRAW left,202,1:DRAW right,202:DRAW right,198:DRAW left,198\r\n50 LOCATE 9,14:PEN 3:PRINT\"Sample length: sampleduration\"\r\n60 FOR k=1 TO samplelength\r\n70 a$=\"SAMP\"+MID$(STR$(k),2)+\".BIN\"\r\n80 |PLAYBANK,k\r\n90 LOAD a$,&4000:PLOT (k*2)+left,200,2\r\n100 NEXT\r\n110 |PLAYSAMPLE,1,samplelength\r\n";
    public JInternalFrame frame;

    void initPlay() {
        try {
            this.checkLine(false);
            STEREO_FORMAT = new AudioFormat(this.SAMPLE_RATE[this.sfreq.getSelectedIndex()], 8, 2, true, false);
            MONO_FORMAT = new AudioFormat(this.SAMPLE_RATE[this.sfreq.getSelectedIndex()], 8, 1, true, false);
            this.channels = 2;
            this.line = AudioSystem.getSourceDataLine(STEREO_FORMAT);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void checkLine(boolean mightbeplaying) {
        if (this.line == null || !this.isPlaying) {
            return;
        }
        if (this.oldmono != this.mono.isSelected()) {
            this.oldmono = this.mono.isSelected();
            this.linepos = this.oldmono ? (this.linepos /= 2) : (this.linepos *= 2);
        }
        this.linepos = Math.toIntExact((long)this.line.getFramePosition() * (long)this.channels + (long)this.linepos);
        if (!this.mono.isSelected()) {
            this.linepos = this.linepos / 2 * 2;
        }
        if (!this.newname.equals(this.filename)) {
            this.newlinepos = 0;
            this.linepos = 0;
            this.newname = this.filename;
        }
        if (this.line.isActive()) {
            this.line.stop();
            this.line.flush();
            this.line.drain();
            this.line.close();
            this.jButton3.setText("Play");
            this.aPanel.setBackground(new Color(0, 0, 0));
            this.bPanel.setBackground(new Color(0, 0, 0));
            if (mightbeplaying && this.isPlaying) {
                this.Play();
            } else {
                this.isPlaying = false;
            }
        }
    }

    void skipLine() {
        if (this.line == null) {
            return;
        }
        this.line.stop();
        this.line.flush();
        this.line.drain();
        this.line.close();
        this.aPanel.setBackground(new Color(0, 0, 0));
        this.bPanel.setBackground(new Color(0, 0, 0));
        this.isPlaying = false;
        this.Play();
    }

    void Play() {
        if (this.line.isActive() || this.export == null) {
            this.checkLine(false);
            return;
        }
        Thread player = new Thread(){

            @Override
            public void run() {
                try {
                    if (WAVtoCPC.this.mono.isSelected()) {
                        WAVtoCPC.this.play = new byte[WAVtoCPC.this.export.length];
                        for (int i = 0; i < WAVtoCPC.this.play.length; ++i) {
                            WAVtoCPC.this.play[i] = (byte)((float)(WAVtoCPC.this.export[i] * WAVtoCPC.this.volumeSet.getValue()) / 100.0f);
                        }
                    } else {
                        WAVtoCPC.this.play = new byte[WAVtoCPC.this.export.length * 2];
                        int off = 0;
                        for (int i = 0; i < WAVtoCPC.this.export.length; ++i) {
                            int leftc = (int)((float)(WAVtoCPC.this.volume[15 - WAVtoCPC.this.left[i]] * WAVtoCPC.this.volumeSet.getValue()) / 100.0f) ^ 0x80;
                            int rightc = (int)((float)(WAVtoCPC.this.volume[15 - WAVtoCPC.this.right[i]] * WAVtoCPC.this.volumeSet.getValue()) / 100.0f) ^ 0x80;
                            WAVtoCPC.this.play[off++] = (byte)leftc;
                            WAVtoCPC.this.play[off++] = (byte)rightc;
                        }
                    }
                    WAVtoCPC.this.jButton3.setText("Stop");
                    WAVtoCPC.this.isPlaying = true;
                    try {
                        MONO_FORMAT = new AudioFormat(WAVtoCPC.this.SAMPLE_RATE[WAVtoCPC.this.sfreq.getSelectedIndex()], 8, 1, true, false);
                        WAVtoCPC.this.channels = WAVtoCPC.this.mono.isSelected() ? 1 : 2;
                        WAVtoCPC.this.line.open(WAVtoCPC.this.mono.isSelected() ? MONO_FORMAT : STEREO_FORMAT, (int)WAVtoCPC.this.SAMPLE_RATE[WAVtoCPC.this.sfreq.getSelectedIndex()] / 12 * (WAVtoCPC.this.mono.isSelected() ? 1 : 2));
                        WAVtoCPC.this.line.start();
                        if (WAVtoCPC.this.newlinepos != 0) {
                            WAVtoCPC.this.linepos = Math.toIntExact((long)WAVtoCPC.this.newlinepos * (long)WAVtoCPC.this.left.length / 696L * (long)WAVtoCPC.this.channels);
                            WAVtoCPC.this.newlinepos = 0;
                        }
                        if (WAVtoCPC.this.linepos % 2 == 1) {
                            ++WAVtoCPC.this.linepos;
                        }
                        WAVtoCPC.this.line.write(WAVtoCPC.this.play, WAVtoCPC.this.linepos, WAVtoCPC.this.play.length - WAVtoCPC.this.linepos);
                        WAVtoCPC.this.line.stop();
                        WAVtoCPC.this.line.flush();
                        WAVtoCPC.this.line.drain();
                        WAVtoCPC.this.line.close();
                        WAVtoCPC.this.jButton3.setText("Play");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        player.start();
    }

    void updateDisplay() {
        try {
            int i;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (WAVtoCPC.this.apanel == null) {
                        WAVtoCPC.this.aVu = new BufferedImage(180, 11, 1);
                        WAVtoCPC.this.bVu = new BufferedImage(180, 11, 1);
                        WAVtoCPC.this.apanel = WAVtoCPC.this.aVu.getGraphics();
                        WAVtoCPC.this.bpanel = WAVtoCPC.this.bVu.getGraphics();
                        WAVtoCPC.this.apanel.setFont(new Font("Verdana", 1, 9));
                        WAVtoCPC.this.bpanel.setFont(new Font("Verdana", 1, 9));
                    }
                }
            });
            if (this.apanel == null) {
                return;
            }
            if (this.left != null) {
                this.samplemillis = (float)this.left.length / this.SAMPLE_RATE[this.sfreq.getSelectedIndex()];
                this.posmillis = (float)(this.line.getFramePosition() + this.linepos / this.channels) / this.SAMPLE_RATE[this.sfreq.getSelectedIndex()];
            }
            if (this.isPlaying) {
                try {
                    this.step = this.left.length / 696;
                    this.pos = (this.line.getFramePosition() + this.linepos / this.channels) / this.step;
                    this.grapos = this.line.getFramePosition() + this.linepos / this.channels;
                }
                catch (Exception e) {
                    this.step = 100;
                    this.pos = 0;
                    this.grapos = 0;
                }
            }
            Graphics2D g = this.ondisplay.createGraphics();
            g.setColor(Color.black);
            g.fillRect(0, 0, 700, 300);
            if (!this.displayinit || this.isMp3 && this.newlinepos == 0) {
                g.drawImage(this.homebase, 0, 6, null);
                g.drawImage(this.homebase, 640, 6, null);
                g.drawImage(this.homesmoke, 376, 132, null);
            }
            if ((!this.isMp3 || this.newlinepos != 0) && this.displayinit) {
                g.drawImage((Image)this.display, 0, 2, null);
                g.setColor(Color.gray);
                g.drawLine(0, 2, 700, 2);
                g.drawLine(0, 259, 700, 259);
            }
            if (this.left != null && this.line != null && this.line.getFramePosition() >= this.left.length) {
                this.checkLine(false);
            }
            try {
                if (this.isPlaying) {
                    this.lc = this.left[this.grapos] - (this.mono.isSelected() ? 0 : 9);
                    this.rc = this.right[this.grapos] - (this.mono.isSelected() ? 0 : 9);
                } else {
                    this.rc = 0;
                    this.lc = 0;
                }
            }
            catch (Exception e) {
                this.lc = 0;
                this.rc = 0;
            }
            this.lc &= 0xF;
            this.rc &= 0xF;
            if (this.lcd < (double)this.lc) {
                this.lcd = this.lc;
            }
            if (this.rcd < (double)this.rc) {
                this.rcd = this.rc;
            }
            if (this.lcdm < (double)this.lc) {
                this.lcdm = this.lcd;
                this.ldelay = 0;
            }
            if (this.rcdm < (double)this.rc) {
                this.rcdm = this.rcd;
                this.rdelay = 0;
            }
            this.haquant = (int)(this.lcd + this.rcd) / 2;
            this.haposy = (float)this.haquant > this.haposy ? (float)((double)this.haposy + 0.125) : (float)((double)this.haposy - 0.125);
            this.oldhagy = 60 + (int)this.haposy * 4;
            int wa = this.aPanel.getWidth();
            int ha = this.aPanel.getHeight();
            int wb = this.bPanel.getWidth();
            int hb = this.bPanel.getHeight();
            this.apanel.setColor(Color.BLACK);
            this.bpanel.setColor(Color.BLACK);
            this.apanel.fillRect(0, 0, wa, ha);
            this.bpanel.fillRect(0, 0, wb, hb);
            this.apanel.setColor(Color.white);
            this.bpanel.setColor(Color.white);
            this.apanel.drawString("L", 8, 10);
            this.bpanel.drawString("R", 8, 10);
            this.apanel.setColor(this.mono.isSelected() ? new Color(0, 64, 64) : new Color(64, 64, 0));
            this.bpanel.setColor(this.mono.isSelected() ? new Color(0, 64, 64) : new Color(0, 64, 0));
            int off = 23;
            for (i = 0; i < 15; ++i) {
                if (i > 13) {
                    this.apanel.setColor(new Color(64, 0, 0));
                }
                this.apanel.fillRect(off, 2, 8, 8);
                off += 10;
            }
            off = 23;
            for (i = 0; i < 15; ++i) {
                if (i > 13) {
                    this.bpanel.setColor(new Color(64, 0, 0));
                }
                this.bpanel.fillRect(off, 2, 8, 8);
                off += 10;
            }
            this.apanel.setColor(this.mono.isSelected() ? Color.CYAN : Color.yellow);
            this.bpanel.setColor(this.mono.isSelected() ? Color.CYAN : Color.GREEN);
            off = 23;
            i = 0;
            while ((double)i < this.lcd) {
                if (i > 13) {
                    this.apanel.setColor(Color.red);
                }
                this.apanel.fillRect(off, 2, 8, 8);
                off += 10;
                ++i;
            }
            off = 23;
            i = 0;
            while ((double)i < this.rcd) {
                if (i > 13) {
                    this.bpanel.setColor(Color.red);
                }
                this.bpanel.fillRect(off, 2, 8, 8);
                off += 10;
                ++i;
            }
            off = 13 + (int)(this.lcdm * 10.0);
            this.apanel.setColor(Color.white);
            this.apanel.fillRect(off + 6, 2, 2, 8);
            off = 13 + (int)(this.rcdm * 10.0);
            this.bpanel.setColor(Color.white);
            this.bpanel.fillRect(off + 6, 2, 2, 8);
            if (this.lcd > 0.0) {
                this.lcd -= 0.5;
            }
            if (this.rcd > 0.0) {
                this.rcd -= 0.5;
            }
            ++this.ldelay;
            if (this.ldelay > 100 && this.lcdm > 0.0) {
                this.lcdm -= 0.025;
            }
            ++this.rdelay;
            if (this.rdelay > 100 && this.rcdm > 0.0) {
                this.rcdm -= 0.025;
            }
            int mins = (int)(this.samplemillis / 60.0f);
            int scs = (int)this.samplemillis % 60;
            int millis = (int)(this.samplemillis * 100.0f) % 100;
            String mn = (mins < 10 ? "0" : "") + mins;
            String sc = (scs < 10 ? "0" : "") + scs;
            String ms = (millis < 10 ? "0" : "") + millis;
            g.setColor(Color.white);
            ((Graphics)g).drawString("Sample length: " + mn + ":" + sc + "." + ms, 550, 274);
            if (this.isPlaying) {
                this.secs = this.posmillis;
            }
            mins = (int)(this.secs / 60.0f);
            scs = (int)this.secs % 60;
            millis = (int)(this.secs * 100.0f) % 100;
            mn = (mins < 10 ? "0" : "") + mins;
            sc = (scs < 10 ? "0" : "") + scs;
            ms = (millis < 10 ? "0" : "") + millis;
            g.setColor(Color.white);
            ((Graphics)g).drawString("Elapsed Time: " + mn + ":" + sc + "." + ms, 4, 274);
            g.drawImage(this.hag, this.poshx, this.oldhagy, this.hag.getWidth(null) * 2, this.hag.getHeight(null) * 2, null);
            if (!(this.isMp3 || this.displayinit || this.isPlaying)) {
                g.setColor(Color.white);
                ((Graphics)g).drawString("WAVtoCPC", this.poshx + 50, this.oldhagy + 36);
                ((Graphics)g).drawString("WAVtoCPC", this.poshx + 51, this.oldhagy + 36);
            } else if (this.isMp3) {
                g.setColor(Color.red);
                ((Graphics)g).drawString("Loading MP3", this.poshx + 50, this.oldhagy + 36);
                ((Graphics)g).drawString("Loading MP3", this.poshx + 51, this.oldhagy + 36);
            }
            --this.poshx;
            if (this.poshx < -120) {
                this.poshx = 700;
            }
            if (this.isMp3) {
                g.drawImage(this.trantor, this.trantorpos, 160, this.trantor.getWidth(null) * 2, this.trantor.getHeight(null) * 2, null);
                this.trantorpos += 2;
                if (this.trantorpos > 690) {
                    this.trantorpos = -90;
                }
            } else {
                this.trantorpos = -90;
            }
            if (this.isPlaying) {
                g.setColor(new Color(255, 255, 255, 100));
                g.fillRect(this.pos - 5, 0, 11, 258);
                g.setColor(Color.red);
                g.drawLine(this.pos, 0, this.pos, 258);
                g.drawImage(this.pumpkin, this.pos - this.pumpkin.getWidth(null) - 2, 236, this.pumpkin.getWidth(null) * 2, this.pumpkin.getHeight(null) * 2, null);
                ++this.posp;
                if (this.posp > 720) {
                    this.posp = 0;
                }
            } else {
                this.posp = 0;
            }
            this.aPanel.setIcon(new ImageIcon(this.aVu));
            this.bPanel.setIcon(new ImageIcon(this.bVu));
            this.jLabel1.setIcon(new ImageIcon(this.ondisplay));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public WAVtoCPC(CPC cpc) {
        this.cpc = cpc;
        this.dia = new FileDialog((Frame)new JFrame(), "Import", 0);
        this.wasplaying = false;
        this.chkdos = new CheckDOS();
        this.skip = true;
        this.disabled = false;
        this.converter = new Converter();
        this.isReading = false;
        this.isMp3 = false;
        this.buffer = new byte[16384];
        this.display = new BufferedImage(696, 280, 2);
        this.ondisplay = new BufferedImage(696, 280, 1);
        this.volumes1 = new int[]{236, 197, 161, 131, 103, 80, 56, 40, 29, 19, 14, 10, 7, 5, 2, 0};
        this.volumeTable = new int[16];
        this.volumes = new int[][]{{236, 197, 161, 131, 103, 80, 56, 40, 29, 19, 14, 10, 7, 5, 2, 0}, {255, 219, 183, 151, 118, 96, 69, 40, 35, 19, 12, 10, 6, 6, 4, 0}, {197, 161, 131, 103, 80, 56, 40, 29, 19, 14, 10, 7, 5, 2, 1, 0}, {255, 214, 180, 143, 113, 90, 65, 40, 34, 21, 15, 10, 6, 4, 3, 0}, {214, 180, 143, 113, 90, 65, 40, 34, 21, 15, 10, 6, 4, 3, 2, 0}, {180, 143, 113, 90, 65, 40, 34, 21, 15, 10, 6, 4, 3, 2, 1, 0}, {255, 180, 128, 90, 64, 45, 32, 23, 16, 11, 8, 6, 4, 3, 2, 0}, {180, 128, 90, 64, 45, 32, 23, 16, 11, 8, 6, 4, 3, 2, 1, 0}};
        this.volume = new int[16];
        this.inverted = true;
        this.raw_sample = true;
        this.compare = new int[]{11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 0, 0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11};
        this.HEADER = new byte[128];
        this.internalname = "           ";
        this.namepos = 1;
        this.filetypepos = 18;
        this.datalengthpos = 19;
        this.datalocationpos = 21;
        this.firstblockpos = 23;
        this.filelengthpos = 24;
        this.execaddresspos = 26;
        this.lengthpos = 64;
        this.checksumpos = 67;
        this.newlinepos = 0;
        URL pump = this.getClass().getResource("pumpkin.gif");
        this.pumpkin = new JFrame().getToolkit().getImage(pump);
        URL ha = this.getClass().getResource("hagleft.gif");
        this.hag = new JFrame().getToolkit().getImage(ha);
        URL tra = this.getClass().getResource("trantor.gif");
        this.trantor = new JFrame().getToolkit().getImage(tra);
        URL home = this.getClass().getResource("homebase.png");
        this.homebase = new JFrame().getToolkit().getImage(home);
        URL homes = this.getClass().getResource("smoke.gif");
        this.homesmoke = new JFrame().getToolkit().getImage(homes);
        this.initComponents();
        this.initPlay();
        this.fillTable();
        this.fireUpdate.start();
    }

    public void Import() {
        this.dia.setFile("*.wav; *.raw; *.sample; *.bin; *.mp3");
        this.dia.setVisible(true);
        if (this.dia.getFile() != null) {
            this.newname = this.dia.getFile();
            this.filename = this.dia.getFile();
            this.newlinepos = 0;
            this.linepos = 0;
            this.wasplaying = false;
            this.line.stop();
            this.line.flush();
            this.line.drain();
            this.line.close();
            this.isPlaying = false;
            if (this.mono.isSelected()) {
                this.ImportMono(this.dia.getDirectory(), this.dia.getFile());
            } else if (this.dia.getFile().toLowerCase().endsWith(".sample")) {
                this.ImportSample(this.dia.getDirectory(), this.dia.getFile());
            } else if (this.dia.getFile().toLowerCase().endsWith(".bin")) {
                this.ImportRawSample(this.dia.getDirectory(), this.dia.getFile());
            } else if (this.dia.getFile().toLowerCase().endsWith(".mp3")) {
                this.ImportMP3(this.dia.getDirectory(), this.dia.getFile());
            } else {
                this.Import(this.dia.getDirectory(), this.dia.getFile());
            }
            this.displayinit = true;
        }
    }

    public int getDWord(byte[] buffer, int offs) {
        return buffer[offs] & 0xFF | (buffer[offs + 1] & 0xFF) << 8 | (buffer[offs + 2] & 0xFF) << 16 | (buffer[offs + 3] & 0xFF) << 24;
    }

    public byte[] ImportRawSample(String path, String file) {
        this.filepath = path;
        this.filename = file;
        File a = new File(path + file);
        byte[] check = new byte[256];
        try {
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(a));
            bin.read(check);
            bin.close();
        }
        catch (Exception bin) {
            // empty catch block
        }
        boolean hasAmsdos = this.chkdos.CheckAMSDOS(check);
        System.out.println("Has AMSDOS header: " + hasAmsdos);
        int size = (int)a.length() - (hasAmsdos ? 128 : 0);
        if (!file.toLowerCase().contains("samp1.bin")) {
            try {
                BufferedInputStream bin = new BufferedInputStream(new FileInputStream(a));
                byte[] sample = new byte[size + (hasAmsdos ? 128 : 0)];
                bin.read(sample);
                bin.close();
                if (hasAmsdos) {
                    byte[] ams = new byte[size - 128];
                    System.arraycopy(sample, 128, ams, 0, ams.length);
                    sample = new byte[ams.length];
                    System.arraycopy(ams, 0, sample, 0, sample.length);
                }
                this.skip = false;
                if (!this.mono.isSelected()) {
                    this.ImportSample(sample, path + file);
                }
                this.checkLine(true);
                return sample;
            }
            catch (Exception bin) {
                // empty catch block
            }
        }
        String first = "SAMP";
        int f = 1;
        a = new File(path + first + f + ".BIN");
        if (!a.exists()) {
            return null;
        }
        while (a.exists()) {
            a = new File(path + first + ++f + ".BIN");
        }
        byte[] buffer = new byte[16512];
        byte[] samples = new byte[16384 * --f];
        int off = 0;
        for (int i = 1; i <= f; ++i) {
            try {
                BufferedInputStream bin = new BufferedInputStream(new FileInputStream(path + first + i + ".BIN"));
                bin.read(buffer);
                bin.close();
                System.arraycopy(buffer, 128, samples, off, 16384);
                off += 16384;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.skip = false;
        if (!this.mono.isSelected()) {
            this.ImportSample(samples, path + file);
        }
        this.checkLine(true);
        return samples;
    }

    protected void enablePanel(boolean dis) {
        this.jButton1.setEnabled(dis);
        this.normalize.setEnabled(dis);
        this.booster.setEnabled(dis);
        this.seperate.setEnabled(dis);
        this.vol.setEnabled(dis);
        this.jCheckBox1.setEnabled(dis);
        this.saveButton.setEnabled(dis);
        this.asSample.setEnabled(dis);
        this.jCheckBox2.setEnabled(!this.asSample.isSelected());
        this.sfreq.setEnabled(dis);
        this.filter.setEnabled(dis);
        this.sendPlayCommand.setEnabled(dis);
        this.jButton3.setEnabled(dis);
        if (dis) {
            this.to14.setEnabled(this.mono.isSelected());
            this.normalize.setEnabled(!this.mono.isSelected());
            this.booster.setEnabled(!this.mono.isSelected());
            this.seperate.setEnabled(!this.mono.isSelected());
            this.vol.setEnabled(!this.mono.isSelected());
            this.jCheckBox1.setEnabled(!this.mono.isSelected());
            this.filter.setEnabled(!this.mono.isSelected());
        }
    }

    public void ImportSample(String path, String file) {
        this.filepath = path;
        this.filename = file;
        this.raw_sample = this.filename.toLowerCase().endsWith(".raw");
        path = path + "/";
        try {
            File a = new File(path + file);
            byte[] data = new byte[(int)a.length()];
            BufferedInputStream bos = new BufferedInputStream(new FileInputStream(a));
            bos.read(data);
            bos.close();
            this.skip = true;
            this.ImportSample(data, path + file);
            this.checkLine(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void Import(String path, String file) {
        if (this.disabled) {
            return;
        }
        if (this.mono.isSelected()) {
            this.ImportMono(path, file);
            return;
        }
        if (file.toLowerCase().endsWith(".mp3")) {
            System.out.println(this.wasplaying);
            this.ImportMP3(path, file);
        }
        if (file.toLowerCase().endsWith(".sample")) {
            this.ImportSample(this.dia.getDirectory(), this.dia.getFile());
            return;
        }
        if (file.toLowerCase().endsWith(".bin")) {
            this.ImportRawSample(this.dia.getDirectory(), this.dia.getFile());
            return;
        }
        path = path + "/";
        try {
            File a = new File(path + file);
            byte[] data = new byte[(int)a.length()];
            BufferedInputStream bos = new BufferedInputStream(new FileInputStream(a));
            bos.read(data);
            bos.close();
            int frequency = this.getDWord(data, 24) & 0xFFFF;
            int error = 0;
            if (frequency != 8000 && frequency != 11025 && frequency != 12000 && frequency != 16000) {
                error = 1;
            }
            frequency /= 1000;
            int bits = this.getWord(data, 34) & 0xFFFF;
            if (bits != 8) {
                error += 2;
            }
            if (error > 0) {
                this.ImportMP3(path, file);
                return;
            }
            switch (frequency) {
                case 16: {
                    this.sfreq.setSelectedIndex(0);
                    this.ImportMP3(path, file);
                    return;
                }
                case 12: {
                    this.sfreq.setSelectedIndex(1);
                    break;
                }
                case 11: {
                    this.sfreq.setSelectedIndex(2);
                    break;
                }
                case 8: {
                    this.sfreq.setSelectedIndex(3);
                }
            }
            this.filepath = path;
            this.filename = file;
            this.raw_sample = this.filename.toLowerCase().endsWith(".raw");
            System.out.println(bits);
            byte[] wav = new byte[data.length - 44];
            System.arraycopy(data, 44, wav, 0, wav.length);
            int idx = 0;
            int bytetoggle = this.bytechange;
            for (int i = 0; i < wav.length - 2; i += 2) {
                data[idx++] = wav[i];
                data[idx++] = wav[i + 1];
                if (this.sfreq.getSelectedIndex() != 0 || i % this.bytechange != 0) continue;
                this.bytechange = this.bytechange == bytetoggle ? bytetoggle + 1 : bytetoggle;
                i += 2;
            }
            wav = new byte[idx];
            if (this.filter.isSelected()) {
                this.Filter(data);
            }
            System.arraycopy(data, 0, wav, 0, wav.length);
            this.Import(wav, path + file);
            this.checkLine(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void ImportMP3(final String p, final String f) {
        if (this.disabled) {
            return;
        }
        if (this.isReading) {
            return;
        }
        this.isReading = true;
        this.enablePanel(false);
        Thread v = new Thread(){

            @Override
            public void run() {
                String path = p;
                String file = f;
                path = path + "/";
                try {
                    AudioInputStream inFileAIS;
                    File a = new File(path + file);
                    WAVtoCPC.this.isMp3 = false;
                    byte[] mp3data = null;
                    if (file.toLowerCase().endsWith(".mp3")) {
                        WAVtoCPC.this.isMp3 = true;
                        mp3data = WAVtoCPC.this.converter.convertToArray(path + file);
                        if (WAVtoCPC.this.newlinepos != 0) {
                            WAVtoCPC.this.newlinepos = WAVtoCPC.this.pos;
                        }
                    }
                    float rate = WAVtoCPC.this.SAMPLE_RATE[WAVtoCPC.this.sfreq.getSelectedIndex()];
                    AudioFormat outDataFormat = new AudioFormat(rate, 8, 2, false, false);
                    if (mp3data != null && WAVtoCPC.this.isMp3) {
                        ByteArrayInputStream bin = new ByteArrayInputStream(mp3data);
                        inFileAIS = AudioSystem.getAudioInputStream(bin);
                    } else {
                        inFileAIS = AudioSystem.getAudioInputStream(a);
                    }
                    AudioInputStream lowResAIS = AudioSystem.getAudioInputStream(outDataFormat, inFileAIS);
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)lowResAIS, (OutputStream)os);
                    byte[] data = os.toByteArray();
                    os.flush();
                    os.close();
                    inFileAIS.close();
                    WAVtoCPC.this.isMp3 = false;
                    WAVtoCPC.this.filepath = path;
                    WAVtoCPC.this.filename = file;
                    byte[] wav = new byte[data.length - 44];
                    System.arraycopy(data, 44, wav, 0, wav.length);
                    int idx = 0;
                    for (int i = 0; i < wav.length - 2; i += 2) {
                        data[idx++] = wav[i];
                        data[idx++] = wav[i + 1];
                    }
                    wav = new byte[idx];
                    if (WAVtoCPC.this.filter.isSelected()) {
                        WAVtoCPC.this.Filter(data);
                    }
                    System.arraycopy(data, 0, wav, 0, wav.length);
                    WAVtoCPC.this.Import(wav, path + file);
                    WAVtoCPC.this.checkLine(true);
                    if (WAVtoCPC.this.wasplaying) {
                        WAVtoCPC.this.Play();
                    }
                    WAVtoCPC.this.displayinit = true;
                    WAVtoCPC.this.wasplaying = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                WAVtoCPC.this.isReading = false;
                WAVtoCPC.this.enablePanel(true);
            }
        };
        v.start();
    }

    public void ImportMono(final String p, final String f) {
        if (this.disabled) {
            return;
        }
        if (this.isReading) {
            return;
        }
        this.isReading = true;
        this.enablePanel(false);
        Thread v = new Thread(){

            @Override
            public void run() {
                String path = p;
                String file = f;
                path = path + "/";
                try {
                    byte[] data;
                    File a = new File(path + file);
                    WAVtoCPC.this.isMp3 = false;
                    byte[] mp3data = null;
                    if (file.toLowerCase().endsWith(".mp3")) {
                        WAVtoCPC.this.isMp3 = true;
                        mp3data = WAVtoCPC.this.converter.convertToArray(path + file);
                        if (WAVtoCPC.this.newlinepos != 0) {
                            WAVtoCPC.this.newlinepos = WAVtoCPC.this.pos;
                        }
                    }
                    float rate = WAVtoCPC.this.SAMPLE_RATE[WAVtoCPC.this.sfreq.getSelectedIndex()];
                    if (file.toLowerCase().endsWith(".mp3") || file.toLowerCase().endsWith(".wav")) {
                        AudioInputStream inFileAIS;
                        AudioFormat outDataFormat = new AudioFormat(rate, 8, 1, true, false);
                        if (mp3data != null && WAVtoCPC.this.isMp3) {
                            ByteArrayInputStream bin = new ByteArrayInputStream(mp3data);
                            inFileAIS = AudioSystem.getAudioInputStream(bin);
                        } else {
                            inFileAIS = AudioSystem.getAudioInputStream(a);
                        }
                        AudioInputStream lowResAIS = AudioSystem.getAudioInputStream(outDataFormat, inFileAIS);
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        IOUtils.copy((InputStream)lowResAIS, (OutputStream)os);
                        data = os.toByteArray();
                        os.flush();
                        os.close();
                        inFileAIS.close();
                    } else if (file.toLowerCase().endsWith(".sample")) {
                        BufferedInputStream bin = new BufferedInputStream(new FileInputStream(a));
                        data = new byte[(int)a.length()];
                        bin.read(data);
                        bin.close();
                        WAVtoCPC.this.displayinit = true;
                    } else {
                        data = WAVtoCPC.this.ImportRawSample(p, f);
                    }
                    WAVtoCPC.this.isMp3 = false;
                    WAVtoCPC.this.filepath = path;
                    WAVtoCPC.this.filename = file;
                    byte[] wav = new byte[data.length - 44];
                    System.arraycopy(data, 44, wav, 0, wav.length);
                    System.arraycopy(wav, 0, data, 0, wav.length - 2);
                    System.arraycopy(data, 0, wav, 0, wav.length);
                    WAVtoCPC.this.ImportMono(wav, path + file);
                    WAVtoCPC.this.checkLine(true);
                    WAVtoCPC.this.isReading = false;
                    WAVtoCPC.this.displayinit = true;
                    if (WAVtoCPC.this.wasplaying) {
                        WAVtoCPC.this.Play();
                    }
                    WAVtoCPC.this.wasplaying = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                WAVtoCPC.this.isReading = false;
                WAVtoCPC.this.enablePanel(true);
            }
        };
        v.start();
    }

    void Filter(byte[] data, byte[] data2) {
        float[] input = new float[data.length];
        float[] prev = new float[data2.length];
        boolean off = false;
        for (int i = 0; i < data.length - 200; ++i) {
            input[i] = (float)(data[i] & 0xFF) / 255.0f;
            prev[i] = (float)(data2[i] & 0xFF) / 255.0f;
        }
        off = false;
        float[] filtered = WAVtoCPC.filter(input, prev);
        for (int j = 0; j < filtered.length; ++j) {
            data[j] = (byte)(filtered[j] * 255.0f);
        }
    }

    void Filter(byte[] data) {
        float[] input = new float[data.length];
        float[] prev = new float[data.length];
        boolean off = false;
        for (int i = 0; i < data.length - 200; ++i) {
            input[i] = (float)(data[i] & 0xFF) / 255.0f;
            prev[i + 200] = (float)(data[i] & 0xFF) / 255.0f;
        }
        off = false;
        float[] filtered = WAVtoCPC.filter(input, prev);
        for (int j = 0; j < filtered.length; ++j) {
            data[j] = (byte)(filtered[j] * 255.0f);
        }
    }

    public static float[] filter(float[] input, float[] prev) {
        if (input == null || prev == null) {
            throw new NullPointerException("input and prev float arrays must be non-NULL");
        }
        if (input.length != prev.length) {
            throw new IllegalArgumentException("input and prev must be the same length");
        }
        for (int i = 0; i < input.length; ++i) {
            prev[i] = prev[i] + 0.75f * (input[i] - prev[i]);
        }
        return prev;
    }

    public static int hexValue(String source) {
        int result = 0;
        source = source.trim();
        for (int i = 0; i < source.length(); ++i) {
            byte val = WAVtoCPC.hexValue(source.charAt(i));
            result = (result << 4) + val;
        }
        return result;
    }

    public static byte hexValue(char value) {
        if (value >= 'a') {
            return (byte)(value - 97 + 10);
        }
        if (value > '9') {
            return (byte)(value - 65 + 10);
        }
        return (byte)(value - 48);
    }

    int swapNibbles(int x) {
        return (x & 0xF) << 4 | (x & 0xF0) >> 4;
    }

    protected void fillTable() {
        this.disabled = true;
        this.booster.setValue(315);
        for (int i = 0; i < 16; ++i) {
            this.volumeTable[i] = this.vol.getSelectedIndex() != 8 ? this.volumes[this.vol.getSelectedIndex()][i] : ~(i * 17) & 0xFF;
        }
        this.vol1.setValue(this.volumeTable[15]);
        this.vol2.setValue(this.volumeTable[14]);
        this.vol3.setValue(this.volumeTable[13]);
        this.vol4.setValue(this.volumeTable[12]);
        this.vol5.setValue(this.volumeTable[11]);
        this.vol6.setValue(this.volumeTable[10]);
        this.vol7.setValue(this.volumeTable[9]);
        this.vol8.setValue(this.volumeTable[8]);
        this.vol9.setValue(this.volumeTable[7]);
        this.vol10.setValue(this.volumeTable[6]);
        this.vol11.setValue(this.volumeTable[5]);
        this.vol12.setValue(this.volumeTable[4]);
        this.vol13.setValue(this.volumeTable[3]);
        this.vol14.setValue(this.volumeTable[2]);
        this.vol15.setValue(this.volumeTable[1]);
        this.vol16.setValue(this.volumeTable[0]);
        this.disabled = false;
    }

    protected int convertToPSG(byte in) {
        int val = in & 0xFF;
        if (this.inverted) {
            for (int i = 0; i < 16; ++i) {
                if (val > 255 - this.volume[i]) continue;
                return 15 - i & 0xF;
            }
        } else {
            for (int i = 0; i < 16; ++i) {
                if (val < this.volume[i]) continue;
                return 15 - i & 0xF;
            }
        }
        return 0;
    }

    public byte[] normalize(byte[] sampleArray) {
        int largest = 0;
        int sample = 0;
        int value = 0;
        for (int i = 0; i < sampleArray.length; i += 2) {
            sample = sampleArray[i] & 0xFF;
            value = Math.abs(sample);
            if (value < largest) continue;
            largest = value;
        }
        double multiplier = (double)this.booster.getValue() / (double)largest;
        System.out.println("Largest value = " + largest + " - Multiplier = " + multiplier);
        for (int j = 0; j < sampleArray.length; ++j) {
            sample = (int)((double)(sampleArray[j] & 0xFF) * multiplier);
            if (sample > 255) {
                sample = 255;
            }
            sampleArray[j] = (byte)sample;
        }
        return sampleArray;
    }

    public byte[] CovertTo8Bit(byte[] sixteen) {
        byte[] eight = new byte[sixteen.length >> 1];
        for (int i = 0; i < eight.length; ++i) {
            byte byteData;
            short sixteenBit = this.getWord(sixteen, i * 2);
            eight[i] = byteData = (byte)(sixteenBit >> 8 ^ 0x80);
        }
        return eight;
    }

    public void putWord(byte[] buffer, int offs, int data) {
        buffer[offs] = (byte)(data & 0xFF);
        buffer[offs + 1] = (byte)(data >> 8 & 0xFF);
    }

    public short getWord(byte[] buffer, int offs) {
        return (short)(buffer[offs] & 0xFF | buffer[offs + 1] << 8 & 0xFF00);
    }

    void defineVolume() {
        this.volume[0] = this.vol16.getValue();
        this.volume[1] = this.vol15.getValue();
        this.volume[2] = this.vol14.getValue();
        this.volume[3] = this.vol13.getValue();
        this.volume[4] = this.vol12.getValue();
        this.volume[5] = this.vol11.getValue();
        this.volume[6] = this.vol10.getValue();
        this.volume[7] = this.vol9.getValue();
        this.volume[8] = this.vol8.getValue();
        this.volume[9] = this.vol7.getValue();
        this.volume[10] = this.vol6.getValue();
        this.volume[11] = this.vol5.getValue();
        this.volume[12] = this.vol4.getValue();
        this.volume[13] = this.vol3.getValue();
        this.volume[14] = this.vol2.getValue();
        this.volume[15] = this.vol1.getValue();
        this.jLabel3.setText("" + this.volume[15]);
        this.jLabel4.setText("" + this.volume[14]);
        this.jLabel5.setText("" + this.volume[13]);
        this.jLabel6.setText("" + this.volume[12]);
        this.jLabel7.setText("" + this.volume[11]);
        this.jLabel8.setText("" + this.volume[10]);
        this.jLabel9.setText("" + this.volume[9]);
        this.jLabel10.setText("" + this.volume[8]);
        this.jLabel11.setText("" + this.volume[7]);
        this.jLabel12.setText("" + this.volume[6]);
        this.jLabel13.setText("" + this.volume[5]);
        this.jLabel14.setText("" + this.volume[4]);
        this.jLabel15.setText("" + this.volume[3]);
        this.jLabel16.setText("" + this.volume[2]);
        this.jLabel17.setText("" + this.volume[1]);
        this.jLabel18.setText("" + this.volume[0]);
    }

    public void ImportSample(byte[] sample, String file) {
        int skipme;
        this.defineVolume();
        int n = skipme = this.skip ? 16384 : 0;
        if (sample.length < 32768) {
            skipme = 0;
        }
        this.export = new byte[sample.length - skipme];
        System.arraycopy(sample, skipme, this.export, 0, this.export.length);
        this.left = new byte[this.export.length];
        this.right = new byte[this.export.length];
        int off = 0;
        for (int i = 0; i < this.export.length; ++i) {
            String byt = Integer.toHexString(this.export[i] & 0xFF).toUpperCase();
            int len = byt.length();
            if (len > 2) {
                byt = byt.substring(len - 2);
            } else if (len < 2) {
                byt = "0" + byt;
            }
            String leftNibble = "" + byt.charAt(1);
            String rightNibble = "" + byt.charAt(0);
            this.left[off] = (byte)Integer.parseInt(leftNibble, 16);
            this.right[off++] = (byte)Integer.parseInt(rightNibble, 16);
        }
        this.display = new BufferedImage(696, 280, 2);
        Graphics2D d = this.display.createGraphics();
        int step = this.left.length / 1392;
        d.setColor(Color.white);
        d.drawLine(0, 128, 696, 128);
        int ti = 0;
        int lastLeft = 256;
        int lastRight = 256;
        for (int j = 0; j < 16; ++j) {
            int posy = j * 8;
            d.setColor(Color.lightGray);
            d.drawLine(0, posy, 800, posy);
            d.drawLine(0, posy + 128, 800, posy + 128);
        }
        BufferedImage ldisplay = new BufferedImage(1392, 560, 2);
        Graphics2D s = ldisplay.createGraphics();
        for (int k = 0; k < this.left.length; k += step) {
            s.setColor(Color.yellow);
            s.drawLine(ti, lastLeft, ti, this.left[k] * 16);
            lastLeft = this.left[k] * 16 & 0xFF;
            s.setColor(Color.green);
            s.drawLine(ti, lastRight + 256, ti++, this.right[k] * 16 + 256);
            lastRight = this.right[k] * 16 & 0xFF;
        }
        Image conv = ldisplay.getScaledInstance(696, -1, 4);
        d.drawImage(conv, 0, 0, 696, 280, null);
        d.setColor(Color.black);
        d.fillRect(0, 0, 10, 400);
        d.setFont(new Font("Verdana", 1, 8));
        for (int m = 0; m < 16; ++m) {
            int posy = m * 8;
            d.setColor(Color.white);
            ((Graphics)d).drawString(Integer.toHexString(m).toUpperCase(), 3, posy + 8);
            ((Graphics)d).drawString(Integer.toHexString(m).toUpperCase(), 3, posy + 136);
            ((Graphics)d).drawString(Integer.toHexString(m).toUpperCase(), 3, posy + 8);
            ((Graphics)d).drawString(Integer.toHexString(m).toUpperCase(), 3, posy + 136);
            ((Graphics)d).drawString(Integer.toHexString(m).toUpperCase(), 684, posy + 8);
            ((Graphics)d).drawString(Integer.toHexString(m).toUpperCase(), 684, posy + 136);
            ((Graphics)d).drawString(Integer.toHexString(m).toUpperCase(), 684, posy + 8);
            ((Graphics)d).drawString(Integer.toHexString(m).toUpperCase(), 684, posy + 136);
        }
        while (file.contains("/")) {
            file = file.substring(1);
        }
        while (file.contains("\\")) {
            file = file.substring(1);
        }
        double banksused = (double)this.export.length / 16384.0;
        double rest = banksused - (double)((int)banksused);
        this.banks = (int)banksused;
        if (rest > 0.0) {
            ++this.banks;
        }
        if (this.banks > 255) {
            this.doWarn();
            this.saveButton.setEnabled(false);
        } else {
            this.doWarn = false;
            this.saveButton.setBackground(this.jButton3.getBackground());
            this.saveButton.setForeground(this.jButton3.getForeground());
            this.saveButton.setEnabled(true);
        }
        double samplesize = (double)this.export.length / 1024.0;
        int size = (int)samplesize;
        rest = samplesize - (double)((int)samplesize);
        String dot = "";
        if (rest > 0.0) {
            dot = "." + (int)(rest *= 10.0);
        }
        String ending = "";
        if (file.length() > 20) {
            String fil = file;
            while (fil.contains(".")) {
                fil = fil.substring(1);
            }
            ending = "(...)." + fil;
        }
        while (file.length() > 20) {
            file = file.substring(0, file.length() - 1);
        }
        file = file + ending;
        this.setTitle("WavToCPC \u00ae 2019-" + Main.year + " by Markus Hohmann - [" + file + "] - " + this.banks + " Banks / " + size + dot + "kb");
        if (this.wasplaying) {
            this.Play();
        }
        this.wasplaying = false;
    }

    public void doWarn() {
        this.blinkWarn = true;
        this.doWarn = true;
        Thread warn = new Thread(){

            @Override
            public void run() {
                while (WAVtoCPC.this.doWarn) {
                    if (WAVtoCPC.this.blinkWarn && WAVtoCPC.this.doWarn) {
                        WAVtoCPC.this.saveButton.setBackground(Color.red);
                        WAVtoCPC.this.saveButton.setForeground(WAVtoCPC.this.jButton3.getForeground());
                    } else if (WAVtoCPC.this.doWarn) {
                        WAVtoCPC.this.saveButton.setBackground(WAVtoCPC.this.jButton3.getBackground());
                        WAVtoCPC.this.saveButton.setForeground(Color.red);
                    } else {
                        WAVtoCPC.this.saveButton.setBackground(WAVtoCPC.this.jButton3.getBackground());
                        WAVtoCPC.this.saveButton.setForeground(WAVtoCPC.this.jButton3.getForeground());
                    }
                    WAVtoCPC.this.blinkWarn = !WAVtoCPC.this.blinkWarn;
                    try {
                        Thread.sleep(250L);
                    }
                    catch (Exception exception) {}
                }
            }
        };
        warn.start();
    }

    protected void setTitle(String title) {
        if (this.frame != null) {
            this.frame.setTitle(title);
        }
        JEMU.wavtocpctitle = title;
        this.tabtitle = title;
    }

    public String getTitle() {
        return this.tabtitle;
    }

    public void Import(byte[] sample, String file) {
        if (this.normalize.isSelected()) {
            sample = this.normalize(sample);
        }
        this.export = new byte[sample.length / 2];
        this.left = new byte[this.export.length];
        this.right = new byte[this.export.length];
        int index = 0;
        this.defineVolume();
        int seperator = this.seperate.isSelected() ? this.seperation[this.sfreq.getSelectedIndex()] : 0;
        for (int i = 0; i < sample.length; i += 2) {
            try {
                this.nibbleLeft = i > seperator ? this.convertToPSG(sample[i - seperator]) : 9;
                this.nibbleRight = this.convertToPSG(sample[i + 1]);
                int stereoByte = this.nibbleLeft | this.nibbleRight << 4;
                this.left[index] = (byte)this.nibbleLeft;
                this.right[index] = (byte)this.nibbleRight;
                if (stereoByte == -1) {
                    stereoByte = -2;
                }
                this.export[index++] = stereoByte;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
        double banksused = (double)this.export.length / 16384.0;
        double rest = banksused - (double)((int)banksused);
        this.banks = (int)banksused;
        if (rest > 0.0) {
            ++this.banks;
        }
        if (this.banks > 255) {
            this.doWarn();
            this.saveButton.setEnabled(false);
        } else {
            this.doWarn = false;
            this.saveButton.setBackground(this.jButton3.getBackground());
            this.saveButton.setForeground(this.jButton3.getForeground());
            this.saveButton.setEnabled(true);
        }
        this.display = new BufferedImage(696, 280, 2);
        Graphics2D d = this.display.createGraphics();
        d.setColor(Color.black);
        int step = this.left.length / 1392;
        d.setColor(Color.white);
        d.drawLine(0, 128, 696, 128);
        int ti = 0;
        int lastLeft = 256;
        int lastRight = 256;
        for (int j = 0; j < 16; ++j) {
            int posy = j * 8;
            d.setColor(Color.lightGray);
            d.drawLine(0, posy, 800, posy);
            d.drawLine(0, posy + 128, 800, posy + 128);
        }
        BufferedImage ldisplay = new BufferedImage(1392, 560, 2);
        Graphics2D s = ldisplay.createGraphics();
        int istep = 1392 / this.banks;
        Color bankeven = new Color(128, 0, 128, 160);
        Color bankodd = new Color(0, 128, 128, 160);
        int l = 0;
        for (int i = 0; i < 1392; i += istep) {
            ++l;
            if ((l %= 2) == 1) {
                s.setColor(bankeven);
            } else {
                s.setColor(bankodd);
            }
            s.fillRect(i, 0, istep, 500);
        }
        for (int k = 0; k < this.left.length; k += step) {
            s.setColor(Color.yellow);
            s.drawLine(ti, lastLeft, ti, this.left[k] * 16);
            lastLeft = this.left[k] * 16 & 0xFF;
            s.setColor(Color.green);
            s.drawLine(ti, lastRight + 256, ti++, this.right[k] * 16 + 256);
            lastRight = this.right[k] * 16 & 0xFF;
        }
        Image conv = ldisplay.getScaledInstance(696, -1, 4);
        d.drawImage(conv, 0, 0, 696, 280, null);
        d.setColor(Color.black);
        d.fillRect(0, 0, 10, 400);
        d.setFont(new Font("Verdana", 1, 8));
        for (int m = 0; m < 16; ++m) {
            int posy = m * 8;
            d.setColor(Color.white);
            ((Graphics)d).drawString(Integer.toHexString(m).toUpperCase(), 3, posy + 8);
            ((Graphics)d).drawString(Integer.toHexString(m).toUpperCase(), 3, posy + 136);
            ((Graphics)d).drawString(Integer.toHexString(m).toUpperCase(), 3, posy + 8);
            ((Graphics)d).drawString(Integer.toHexString(m).toUpperCase(), 3, posy + 136);
            ((Graphics)d).drawString(Integer.toHexString(m).toUpperCase(), 684, posy + 8);
            ((Graphics)d).drawString(Integer.toHexString(m).toUpperCase(), 684, posy + 136);
            ((Graphics)d).drawString(Integer.toHexString(m).toUpperCase(), 684, posy + 8);
            ((Graphics)d).drawString(Integer.toHexString(m).toUpperCase(), 684, posy + 136);
        }
        index = 0;
        while (file.contains("/")) {
            file = file.substring(1);
        }
        while (file.contains("\\")) {
            file = file.substring(1);
        }
        String ending = "";
        if (file.length() > 20) {
            String fil = file;
            while (fil.contains(".")) {
                fil = fil.substring(1);
            }
            ending = "(...)." + fil;
        }
        while (file.length() > 20) {
            file = file.substring(0, file.length() - 1);
        }
        file = file + ending;
        this.displayinit = true;
        double samplesize = (double)this.export.length / 1024.0;
        int size = (int)samplesize;
        rest = samplesize - (double)((int)samplesize);
        String dot = "";
        if (rest > 0.0) {
            dot = "." + (int)(rest *= 10.0);
        }
        this.setTitle("WavToCPC \u00ae 2019-" + Main.year + " by Markus Hohmann - [" + file + "] - " + this.banks + " Banks / " + size + dot + "kb");
    }

    public void ImportMono(byte[] sample, String file) {
        this.export = new byte[sample.length];
        this.left = new byte[this.export.length];
        this.right = new byte[this.export.length];
        this.defineVolume();
        for (int i = 0; i < sample.length; ++i) {
            try {
                int audioByte = sample[i] & 0xFF;
                if (audioByte == 255) {
                    audioByte = -2;
                }
                this.right[i] = (byte)(audioByte ^ 0x80);
                this.left[i] = (byte)(audioByte ^ 0x80);
                this.export[i] = (byte)audioByte;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
        this.display = new BufferedImage(696, 280, 2);
        Graphics2D d = this.display.createGraphics();
        int step = this.left.length / 1392;
        d.setColor(Color.white);
        d.drawLine(0, 128, 696, 128);
        int ti = 0;
        int lastLeft = 256;
        int lastRight = 256;
        this.banks = this.export.length / 16384 + 1;
        for (int j = 0; j < 16; ++j) {
            int posy = j * 8;
            d.setColor(Color.lightGray);
            d.drawLine(0, posy, 800, posy);
            d.drawLine(0, posy + 128, 800, posy + 128);
        }
        BufferedImage ldisplay = new BufferedImage(1392, 560, 2);
        Graphics2D s = ldisplay.createGraphics();
        for (int k = 0; k < this.left.length; k += step) {
            s.setColor(Color.CYAN);
            s.drawLine(ti, lastLeft, ti++, (this.left[k] & 0xFF) * 2);
            lastLeft = (this.left[k] & 0xFF) * 2;
        }
        Image conv = ldisplay.getScaledInstance(696, -1, 4);
        d.drawImage(conv, 0, 0, 696, 280, null);
        d.setColor(Color.black);
        d.fillRect(0, 0, 10, 400);
        d.setFont(new Font("Verdana", 1, 8));
        for (int m = 0; m < 16; ++m) {
            int posy = m * 8;
            d.setColor(Color.white);
            ((Graphics)d).drawString(Integer.toHexString(m).toUpperCase(), 3, posy + 8);
            ((Graphics)d).drawString(Integer.toHexString(m).toUpperCase(), 3, posy + 136);
            ((Graphics)d).drawString(Integer.toHexString(m).toUpperCase(), 3, posy + 8);
            ((Graphics)d).drawString(Integer.toHexString(m).toUpperCase(), 3, posy + 136);
            ((Graphics)d).drawString(Integer.toHexString(m).toUpperCase(), 684, posy + 8);
            ((Graphics)d).drawString(Integer.toHexString(m).toUpperCase(), 684, posy + 136);
            ((Graphics)d).drawString(Integer.toHexString(m).toUpperCase(), 684, posy + 8);
            ((Graphics)d).drawString(Integer.toHexString(m).toUpperCase(), 684, posy + 136);
        }
        while (file.contains("/")) {
            file = file.substring(1);
        }
        while (file.contains("\\")) {
            file = file.substring(1);
        }
        if (this.banks > 255) {
            this.doWarn();
            this.saveButton.setEnabled(false);
        } else {
            this.doWarn = false;
            this.saveButton.setBackground(this.jButton3.getBackground());
            this.saveButton.setForeground(this.jButton3.getForeground());
            this.saveButton.setEnabled(true);
        }
        String ending = "";
        if (file.length() > 20) {
            String fil = file;
            while (fil.contains(".")) {
                fil = fil.substring(1);
            }
            ending = "(...)." + fil;
        }
        while (file.length() > 20) {
            file = file.substring(0, file.length() - 1);
        }
        file = file + ending;
        this.displayinit = true;
        this.setTitle("WavToCPC \u00ae 2019-" + Main.year + " by Markus Hohmann - [" + file + "] - " + this.banks + " Banks / " + this.export.length / 1024 + "kb");
    }

    public void Save() {
        if (this.asSample.isSelected()) {
            this.writeSample();
        } else {
            this.writeSamples();
        }
    }

    public void moveSample() {
        this.cpc.stop();
        int bank = this.banks;
        if (bank > 255) {
            bank = 255;
        }
        String call = "";
        if (this.sendPlayCommand.isSelected() && CPC.PEEK(36864) != 195 && CPC.PEEK(36880) != 42 && CPC.PEEK(36896) != 42) {
            this.cpc.loadInternal("CODE.BIN", 36096, 4969);
            call = "CALL &8D00:" + call;
        }
        int fr = this.CPCRate[this.sfreq.getSelectedIndex()];
        if (!this.to14.isSelected() && this.mono.isSelected() && this.sfreq.getSelectedIndex() == 0) {
            fr = 16;
            call = call + "|DRIVER,1:|SPEED,16:";
        }
        if (this.mono.isSelected()) {
            switch (fr) {
                case 14: {
                    call = call + "|SPEED,14:";
                    break;
                }
                case 12: {
                    call = call + "|SPEED,12:";
                    break;
                }
                case 11: {
                    call = call + "|SPEED,11:";
                    break;
                }
                case 8: {
                    call = call + "|SPEED,8:";
                    break;
                }
                case 6: {
                    call = call + "|SPEED,6:";
                    break;
                }
                case 5: {
                    call = call + "|SPEED,5:";
                    break;
                }
                case 4: {
                    call = call + "|SPEED,4:";
                }
            }
            call = call + "|PLAYMONO,1," + bank;
        } else {
            switch (fr) {
                case 14: {
                    call = call + "|FREQ.14:";
                    break;
                }
                case 12: {
                    call = call + "|FREQ.12:";
                    break;
                }
                case 11: {
                    call = call + "|FREQ.11:";
                    break;
                }
                case 8: {
                    call = call + "|FREQ.8:";
                    break;
                }
                case 6: {
                    call = call + "|FREQ.6:";
                    break;
                }
                case 5: {
                    call = call + "|FREQ.6:";
                    break;
                }
                case 4: {
                    call = call + "|FREQ.4:";
                }
            }
            call = call + "|PLAYSAMPLE,1," + bank;
        }
        byte[] audiodata = new byte[this.export.length + 10];
        for (int i = audiodata.length - 20; i < audiodata.length; ++i) {
            audiodata[i] = -1;
        }
        System.arraycopy(this.export, 0, audiodata, 0, this.export.length);
        this.cpc.SAMP_Load(audiodata);
        this.cpc.start();
        if (this.sendPlayCommand.isSelected()) {
            this.cpc.BasicAutoType(call + "\r\n");
            this.sendPlayCommand.setSelected(false);
        }
        this.cpc.reSync();
    }

    public void writeSample() {
        String name;
        if (this.saveAs == null) {
            this.saveAs = new FileDialog((Frame)new JFrame(), "Store file", 1);
        }
        String file = name = this.filename;
        file = file.replace(".wav", "");
        file = file.replace(".mp3", "");
        file = this.export.length < 32768 ? file + ".BIN" : file + ".SAMPLE";
        this.saveAs.setFile(file);
        this.saveAs.setVisible(true);
        if (this.saveAs.getFile() != null) {
            file = this.saveAs.getDirectory() + this.saveAs.getFile();
        }
        if (file != null) {
            if (!file.toLowerCase().endsWith(".SAMPLE")) {
                file = file + ".SAMPLE";
            }
            try {
                int j;
                int v;
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(file)));
                for (int it = 0; it < this.buffer.length; ++it) {
                    this.buffer[it] = -103;
                }
                for (int i = this.export.length - 1; i > this.export.length - 16384 && (v = this.export[i] & 0xFF) == 254; --i) {
                    this.export[i] = -1;
                }
                if (!this.mono.isSelected() && this.export.length > 36863) {
                    bos.write(this.buffer);
                }
                if (this.export.length < 32768) {
                    bos.write(this.export);
                    bos.close();
                    return;
                }
                bos.write(this.export);
                int size = this.buffer.length + this.export.length;
                int check = 16 - size % 17;
                for (j = 0; j < check; ++j) {
                    bos.write(-1);
                }
                if (check < 4) {
                    for (j = 0; j < 16; ++j) {
                        ++check;
                        bos.write(-1);
                    }
                }
                bos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public byte[] getBinHeader(int start, int length, String intname) {
        int type = 2;
        int exec = 0;
        this.HEADER = new byte[128];
        while (intname.contains(".")) {
            intname = intname.substring(0, intname.length() - 1);
        }
        while (intname.length() > 11) {
            intname = intname.substring(0, intname.length() - 1);
        }
        intname = intname.toUpperCase();
        try {
            System.arraycopy("           ".getBytes("UTF-8"), 0, this.HEADER, this.namepos, 11);
            System.arraycopy(intname.getBytes("UTF-8"), 0, this.HEADER, this.namepos, intname.length());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.HEADER[this.filetypepos] = (byte)type;
        Util.putWord(this.HEADER, this.datalengthpos, length);
        Util.putWord(this.HEADER, this.datalocationpos, start);
        this.HEADER[this.firstblockpos] = -1;
        Util.putWord(this.HEADER, this.filelengthpos, length);
        Util.putWord(this.HEADER, this.execaddresspos, exec);
        Util.put24Bit(this.HEADER, this.lengthpos, length);
        Util.put24Bit(this.HEADER, this.checksumpos, this.ChecksumAMSDOS(this.HEADER));
        return this.HEADER;
    }

    public int ChecksumAMSDOS(byte[] pHeader) {
        int Checksum2 = 0;
        for (int i = 0; i < 67; ++i) {
            int CheckSumByte = pHeader[i] & 0xFF;
            Checksum2 += CheckSumByte;
        }
        return Checksum2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRom(String name, int size) {
        byte[] buffer = new byte[size];
        int offs = 0;
        try (InputStream stream = null;){
            InputStream is;
            stream = is = this.getClass().getResourceAsStream(name);
            while (size > 0) {
                int read = stream.read(buffer, offs, size);
                if (read == -1) {
                    break;
                }
                offs += read;
                size -= read;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buffer;
    }

    public void writeSamples() {
        int index = 0;
        try {
            double k = (double)this.export.length / 16384.0;
            System.out.println("Sample length: " + this.export.length);
            System.out.println("Sample parts : " + k);
            int b = (int)k;
            double c = k - (double)b;
            int last = 0;
            if (c > 0.0) {
                ++b;
                last = 1;
            }
            int g = 1;
            if (this.saveAs == null) {
                this.saveAs = new FileDialog((Frame)new JFrame(), "Store file", 1);
            }
            String name = "SAMP1.BIN";
            this.saveAs.setFile(name);
            this.saveAs.setVisible(true);
            if (this.saveAs.getFile() != null) {
                name = this.saveAs.getDirectory();
            }
            if (this.export.length < 32768) {
                if (!(name = name + this.saveAs.getFile()).toLowerCase().endsWith(".bin")) {
                    name = name + ".bin";
                }
                int start = 16384;
                if (this.export.length > 16383) {
                    start = this.export.length > 20479 ? (this.export.length > 24575 ? (this.export.length > 28671 ? 1280 : 4096) : 8192) : 12288;
                }
                File f = new File(name);
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
                bos.write(this.getBinHeader(start, this.export.length, "WAVTOCPC"));
                bos.write(this.export);
                bos.close();
                return;
            }
            this.buffer = new byte[16384];
            if (this.export.length < this.buffer.length) {
                this.buffer = new byte[this.export.length];
            }
            byte[] code = this.getRom("CODE.BIN", 5097);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(name + "CODE.BIN")));
            bos.write(code);
            bos.close();
            String bas = this.basCode.replace("samplelength", "" + this.banks);
            int allbk = this.banks * 2;
            int left = (640 - (allbk + 2)) / 2;
            int right = left + allbk + 2;
            bas = bas.replace("left", "" + left);
            bas = bas.replace("right", "" + right);
            if (!this.mono.isSelected()) {
                bas = bas.replace("frequency", "FREQ." + this.CPCRate[this.sfreq.getSelectedIndex()]);
            } else {
                if (!this.to14.isSelected() && this.sfreq.getSelectedIndex() == 0) {
                    bas = "5 MODE 1:PRINT\"16khz Sample.\":INPUT\"Driver (1=Digiblaster, 2=Amdrum):\",a:IF a>2 OR a<1 THEN RUN\r\n" + bas;
                    bas = bas.replace("frequency", "DRIVER,1:|SPEED,16");
                } else {
                    bas = "5 MODE 1:PRINT\"" + this.CPCRate[this.sfreq.getSelectedIndex()] + "khz Sample.\":INPUT\"Driver (0=AY, 1=Digiblaster, 2=Amdrum):\",a:IF a>2 OR a<0 THEN RUN\r\n" + bas;
                    bas = bas.replace("frequency", "SPEED," + this.CPCRate[this.sfreq.getSelectedIndex()]);
                }
                bas = bas.replace("|PLAYSAMPLE", "|DRIVER,a:|PLAYMONO");
            }
            int mins = (int)(this.samplemillis / 60.0f);
            int scs = (int)this.samplemillis % 60;
            int millis = (int)(this.samplemillis * 100.0f) % 100;
            String mn = (mins < 10 ? "0" : "") + mins;
            String sc = (scs < 10 ? "0" : "") + scs;
            String ms = (millis < 10 ? "0" : "") + millis;
            String len = mn + ":" + sc + "." + ms;
            bas = bas.replace("sampleduration", len);
            code = bas.getBytes("UTF-8");
            bos = new BufferedOutputStream(new FileOutputStream(new File(name + "DISC.BAS")));
            bos.write(code);
            bos.close();
            for (int i = 1; i < b; ++i) {
                String nam = name + "SAMP" + g + ".BIN";
                File f = new File(nam);
                if (!this.jCheckBox2.isSelected()) {
                    while (f.exists()) {
                        nam = name + "SAMP" + ++g + ".BIN";
                        f = new File(nam);
                    }
                }
                ++g;
                bos = new BufferedOutputStream(new FileOutputStream(f));
                for (int it = 0; it < this.buffer.length; ++it) {
                    this.buffer[it] = -1;
                }
                System.arraycopy(this.export, index, this.buffer, 0, this.buffer.length);
                if (i == b - 1 && last == 0) {
                    int v;
                    for (int gg = this.buffer.length - 1; gg > this.buffer.length - 16384 && (v = this.buffer[i] & 0xFF) == 254; --gg) {
                        this.buffer[gg] = -1;
                    }
                }
                bos.write(this.getBinHeader(16384, this.buffer.length, "SAMP" + g + ".BIN"));
                bos.write(this.buffer);
                index += this.buffer.length;
                bos.close();
            }
            if (last > 0) {
                String nam = name + "SAMP" + g + ".BIN";
                bos = new BufferedOutputStream(new FileOutputStream(new File(nam)));
                for (int it = 0; it < this.buffer.length; ++it) {
                    this.buffer[it] = -1;
                }
                for (int j = 0; j < this.buffer.length; ++j) {
                    try {
                        this.buffer[j] = this.export[index + j];
                        continue;
                    }
                    catch (Exception ex) {
                        System.out.println("Bytes of last part:" + j);
                        break;
                    }
                }
                bos.write(this.getBinHeader(16384, 16384, "SAMP" + g + ".BIN"));
                bos.write(this.buffer);
                bos.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.normalize = new JCheckBox();
        this.booster = new JSlider();
        this.vol = new JComboBox();
        this.jLabel2 = new JLabel();
        this.vol1 = new JSlider();
        this.vol2 = new JSlider();
        this.vol4 = new JSlider();
        this.vol3 = new JSlider();
        this.vol8 = new JSlider();
        this.vol7 = new JSlider();
        this.vol6 = new JSlider();
        this.vol5 = new JSlider();
        this.vol9 = new JSlider();
        this.vol12 = new JSlider();
        this.vol11 = new JSlider();
        this.vol10 = new JSlider();
        this.vol15 = new JSlider();
        this.vol14 = new JSlider();
        this.vol13 = new JSlider();
        this.vol16 = new JSlider();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jLabel18 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.saveButton = new JButton();
        this.asSample = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.jButton3 = new JButton();
        this.VUMeter = new JPanel();
        this.seperate = new JCheckBox();
        this.jLabel19 = new JLabel();
        this.sfreq = new JComboBox();
        this.filter = new JCheckBox();
        this.sendPlayCommand = new JCheckBox();
        this.jLabel20 = new JButton();
        this.mono = new JCheckBox();
        this.to14 = new JCheckBox();
        this.jLabel21 = new JLabel();
        this.volumeSet = new JSlider();
        this.setTitle("WavToCPC \u00ae 2019-" + Main.year + " by Markus Hohmann");
        this.jButton1.setText("Import");
        this.jButton1.setFocusable(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WAVtoCPC.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                WAVtoCPC.this.jLabel1MouseClicked(evt);
            }
        });
        this.normalize.setSelected(true);
        this.normalize.setText("Normalize");
        this.normalize.setFocusable(false);
        this.normalize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WAVtoCPC.this.normalizeActionPerformed(evt);
            }
        });
        this.booster.setMajorTickSpacing(10);
        this.booster.setMaximum(355);
        this.booster.setMinimum(255);
        this.booster.setPaintTicks(true);
        this.booster.setValue(315);
        this.booster.setFocusable(false);
        this.booster.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                WAVtoCPC.this.boosterMouseReleased(evt);
            }
        });
        this.vol.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "L"}));
        this.vol.setFocusable(false);
        this.vol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WAVtoCPC.this.volActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Vol. Table:");
        this.vol1.setMaximum(255);
        this.vol1.setOrientation(1);
        this.vol1.setBorder(BorderFactory.createEtchedBorder());
        this.vol1.setMaximumSize(new Dimension(11, 150));
        this.vol1.setMinimumSize(new Dimension(11, 150));
        this.vol1.setPreferredSize(new Dimension(11, 150));
        this.vol1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WAVtoCPC.this.vol1StateChanged(evt);
            }
        });
        this.vol2.setMaximum(255);
        this.vol2.setOrientation(1);
        this.vol2.setBorder(BorderFactory.createEtchedBorder());
        this.vol2.setMaximumSize(new Dimension(11, 150));
        this.vol2.setMinimumSize(new Dimension(11, 150));
        this.vol2.setPreferredSize(new Dimension(11, 150));
        this.vol2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WAVtoCPC.this.vol2StateChanged(evt);
            }
        });
        this.vol4.setMaximum(255);
        this.vol4.setOrientation(1);
        this.vol4.setBorder(BorderFactory.createEtchedBorder());
        this.vol4.setMaximumSize(new Dimension(11, 150));
        this.vol4.setMinimumSize(new Dimension(11, 150));
        this.vol4.setPreferredSize(new Dimension(11, 150));
        this.vol4.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WAVtoCPC.this.vol4StateChanged(evt);
            }
        });
        this.vol3.setMaximum(255);
        this.vol3.setOrientation(1);
        this.vol3.setBorder(BorderFactory.createEtchedBorder());
        this.vol3.setMaximumSize(new Dimension(11, 150));
        this.vol3.setMinimumSize(new Dimension(11, 150));
        this.vol3.setPreferredSize(new Dimension(11, 150));
        this.vol3.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WAVtoCPC.this.vol3StateChanged(evt);
            }
        });
        this.vol8.setMaximum(255);
        this.vol8.setOrientation(1);
        this.vol8.setBorder(BorderFactory.createEtchedBorder());
        this.vol8.setMaximumSize(new Dimension(11, 150));
        this.vol8.setMinimumSize(new Dimension(11, 150));
        this.vol8.setPreferredSize(new Dimension(11, 150));
        this.vol8.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WAVtoCPC.this.vol8StateChanged(evt);
            }
        });
        this.vol7.setMaximum(255);
        this.vol7.setOrientation(1);
        this.vol7.setBorder(BorderFactory.createEtchedBorder());
        this.vol7.setMaximumSize(new Dimension(11, 150));
        this.vol7.setMinimumSize(new Dimension(11, 150));
        this.vol7.setPreferredSize(new Dimension(11, 150));
        this.vol7.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WAVtoCPC.this.vol7StateChanged(evt);
            }
        });
        this.vol6.setMaximum(255);
        this.vol6.setOrientation(1);
        this.vol6.setBorder(BorderFactory.createEtchedBorder());
        this.vol6.setMaximumSize(new Dimension(11, 150));
        this.vol6.setMinimumSize(new Dimension(11, 150));
        this.vol6.setPreferredSize(new Dimension(11, 150));
        this.vol6.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WAVtoCPC.this.vol6StateChanged(evt);
            }
        });
        this.vol5.setMaximum(255);
        this.vol5.setOrientation(1);
        this.vol5.setBorder(BorderFactory.createEtchedBorder());
        this.vol5.setMaximumSize(new Dimension(11, 150));
        this.vol5.setMinimumSize(new Dimension(11, 150));
        this.vol5.setPreferredSize(new Dimension(11, 150));
        this.vol5.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WAVtoCPC.this.vol5StateChanged(evt);
            }
        });
        this.vol9.setMaximum(255);
        this.vol9.setOrientation(1);
        this.vol9.setBorder(BorderFactory.createEtchedBorder());
        this.vol9.setMaximumSize(new Dimension(11, 150));
        this.vol9.setMinimumSize(new Dimension(11, 150));
        this.vol9.setPreferredSize(new Dimension(11, 150));
        this.vol9.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WAVtoCPC.this.vol9StateChanged(evt);
            }
        });
        this.vol12.setMaximum(255);
        this.vol12.setOrientation(1);
        this.vol12.setBorder(BorderFactory.createEtchedBorder());
        this.vol12.setMaximumSize(new Dimension(11, 150));
        this.vol12.setMinimumSize(new Dimension(11, 150));
        this.vol12.setPreferredSize(new Dimension(11, 150));
        this.vol12.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WAVtoCPC.this.vol12StateChanged(evt);
            }
        });
        this.vol11.setMaximum(255);
        this.vol11.setOrientation(1);
        this.vol11.setBorder(BorderFactory.createEtchedBorder());
        this.vol11.setMaximumSize(new Dimension(11, 150));
        this.vol11.setMinimumSize(new Dimension(11, 150));
        this.vol11.setPreferredSize(new Dimension(11, 150));
        this.vol11.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WAVtoCPC.this.vol11StateChanged(evt);
            }
        });
        this.vol10.setMaximum(255);
        this.vol10.setOrientation(1);
        this.vol10.setBorder(BorderFactory.createEtchedBorder());
        this.vol10.setMaximumSize(new Dimension(11, 150));
        this.vol10.setMinimumSize(new Dimension(11, 150));
        this.vol10.setPreferredSize(new Dimension(11, 150));
        this.vol10.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WAVtoCPC.this.vol10StateChanged(evt);
            }
        });
        this.vol15.setMaximum(255);
        this.vol15.setOrientation(1);
        this.vol15.setBorder(BorderFactory.createEtchedBorder());
        this.vol15.setMaximumSize(new Dimension(11, 150));
        this.vol15.setMinimumSize(new Dimension(11, 150));
        this.vol15.setPreferredSize(new Dimension(11, 150));
        this.vol15.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WAVtoCPC.this.vol15StateChanged(evt);
            }
        });
        this.vol14.setMaximum(255);
        this.vol14.setOrientation(1);
        this.vol14.setBorder(BorderFactory.createEtchedBorder());
        this.vol14.setMaximumSize(new Dimension(11, 150));
        this.vol14.setMinimumSize(new Dimension(11, 150));
        this.vol14.setPreferredSize(new Dimension(11, 150));
        this.vol14.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WAVtoCPC.this.vol14StateChanged(evt);
            }
        });
        this.vol13.setMaximum(255);
        this.vol13.setOrientation(1);
        this.vol13.setBorder(BorderFactory.createEtchedBorder());
        this.vol13.setMaximumSize(new Dimension(11, 150));
        this.vol13.setMinimumSize(new Dimension(11, 150));
        this.vol13.setPreferredSize(new Dimension(11, 150));
        this.vol13.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WAVtoCPC.this.vol13StateChanged(evt);
            }
        });
        this.vol16.setMaximum(255);
        this.vol16.setOrientation(1);
        this.vol16.setBorder(BorderFactory.createEtchedBorder());
        this.vol16.setMaximumSize(new Dimension(11, 150));
        this.vol16.setMinimumSize(new Dimension(11, 150));
        this.vol16.setPreferredSize(new Dimension(11, 150));
        this.vol16.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WAVtoCPC.this.vol16StateChanged(evt);
            }
        });
        this.jLabel3.setText("0");
        this.jLabel3.setBorder(new SoftBevelBorder(1));
        this.jLabel3.setMaximumSize(new Dimension(11, 20));
        this.jLabel3.setMinimumSize(new Dimension(11, 20));
        this.jLabel3.setPreferredSize(new Dimension(11, 20));
        this.jLabel4.setText("0");
        this.jLabel4.setBorder(new SoftBevelBorder(1));
        this.jLabel4.setMaximumSize(new Dimension(11, 20));
        this.jLabel4.setMinimumSize(new Dimension(11, 20));
        this.jLabel4.setPreferredSize(new Dimension(11, 20));
        this.jLabel5.setText("0");
        this.jLabel5.setBorder(new SoftBevelBorder(1));
        this.jLabel5.setMaximumSize(new Dimension(11, 20));
        this.jLabel5.setMinimumSize(new Dimension(11, 20));
        this.jLabel5.setPreferredSize(new Dimension(11, 20));
        this.jLabel6.setText("0");
        this.jLabel6.setBorder(new SoftBevelBorder(1));
        this.jLabel6.setMaximumSize(new Dimension(11, 20));
        this.jLabel6.setMinimumSize(new Dimension(11, 20));
        this.jLabel6.setPreferredSize(new Dimension(11, 20));
        this.jLabel7.setText("0");
        this.jLabel7.setBorder(new SoftBevelBorder(1));
        this.jLabel7.setMaximumSize(new Dimension(11, 20));
        this.jLabel7.setMinimumSize(new Dimension(11, 20));
        this.jLabel7.setPreferredSize(new Dimension(11, 20));
        this.jLabel8.setText("0");
        this.jLabel8.setBorder(new SoftBevelBorder(1));
        this.jLabel8.setMaximumSize(new Dimension(11, 20));
        this.jLabel8.setMinimumSize(new Dimension(11, 20));
        this.jLabel8.setPreferredSize(new Dimension(11, 20));
        this.jLabel9.setText("0");
        this.jLabel9.setBorder(new SoftBevelBorder(1));
        this.jLabel9.setMaximumSize(new Dimension(11, 20));
        this.jLabel9.setMinimumSize(new Dimension(11, 20));
        this.jLabel9.setPreferredSize(new Dimension(11, 20));
        this.jLabel10.setText("0");
        this.jLabel10.setBorder(new SoftBevelBorder(1));
        this.jLabel10.setMaximumSize(new Dimension(11, 20));
        this.jLabel10.setMinimumSize(new Dimension(11, 20));
        this.jLabel10.setPreferredSize(new Dimension(11, 20));
        this.jLabel11.setText("0");
        this.jLabel11.setBorder(new SoftBevelBorder(1));
        this.jLabel11.setMaximumSize(new Dimension(11, 20));
        this.jLabel11.setMinimumSize(new Dimension(11, 20));
        this.jLabel11.setPreferredSize(new Dimension(11, 20));
        this.jLabel12.setText("0");
        this.jLabel12.setBorder(new SoftBevelBorder(1));
        this.jLabel12.setMaximumSize(new Dimension(11, 20));
        this.jLabel12.setMinimumSize(new Dimension(11, 20));
        this.jLabel12.setPreferredSize(new Dimension(11, 20));
        this.jLabel13.setText("0");
        this.jLabel13.setBorder(new SoftBevelBorder(1));
        this.jLabel13.setMaximumSize(new Dimension(11, 20));
        this.jLabel13.setMinimumSize(new Dimension(11, 20));
        this.jLabel13.setPreferredSize(new Dimension(11, 20));
        this.jLabel14.setText("0");
        this.jLabel14.setBorder(new SoftBevelBorder(1));
        this.jLabel14.setMaximumSize(new Dimension(11, 20));
        this.jLabel14.setMinimumSize(new Dimension(11, 20));
        this.jLabel14.setPreferredSize(new Dimension(11, 20));
        this.jLabel15.setText("0");
        this.jLabel15.setBorder(new SoftBevelBorder(1));
        this.jLabel15.setMaximumSize(new Dimension(11, 20));
        this.jLabel15.setMinimumSize(new Dimension(11, 20));
        this.jLabel15.setPreferredSize(new Dimension(11, 20));
        this.jLabel16.setText("0");
        this.jLabel16.setBorder(new SoftBevelBorder(1));
        this.jLabel16.setMaximumSize(new Dimension(11, 20));
        this.jLabel16.setMinimumSize(new Dimension(11, 20));
        this.jLabel16.setPreferredSize(new Dimension(11, 20));
        this.jLabel17.setText("0");
        this.jLabel17.setBorder(new SoftBevelBorder(1));
        this.jLabel17.setMaximumSize(new Dimension(11, 20));
        this.jLabel17.setMinimumSize(new Dimension(11, 20));
        this.jLabel17.setPreferredSize(new Dimension(11, 20));
        this.jLabel18.setText("0");
        this.jLabel18.setBorder(new SoftBevelBorder(1));
        this.jLabel18.setMaximumSize(new Dimension(11, 20));
        this.jLabel18.setMinimumSize(new Dimension(11, 20));
        this.jLabel18.setPreferredSize(new Dimension(11, 20));
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.setText("Invert");
        this.jCheckBox1.setFocusable(false);
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WAVtoCPC.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.saveButton.setText("Save");
        this.saveButton.setFocusable(false);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WAVtoCPC.this.jButton2ActionPerformed(evt);
            }
        });
        this.asSample.setText(".SAMPLE");
        this.asSample.setFocusable(false);
        this.asSample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WAVtoCPC.this.asSampleActionPerformed(evt);
            }
        });
        this.jCheckBox2.setSelected(true);
        this.jCheckBox2.setText("Overwrite");
        this.jCheckBox2.setFocusable(false);
        this.jButton3.setText("Play");
        this.jButton3.setFocusable(false);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WAVtoCPC.this.jButton3ActionPerformed(evt);
            }
        });
        this.VUMeter.setBackground(new Color(102, 102, 102));
        this.VUMeter.setBorder(BorderFactory.createEtchedBorder());
        this.VUMeter.setMaximumSize(new Dimension(180, 30));
        this.VUMeter.setMinimumSize(new Dimension(180, 30));
        this.VUMeter.setPreferredSize(new Dimension(180, 30));
        this.VUMeter.setLayout(new BorderLayout());
        this.aPanel.setBackground(new Color(0, 0, 0));
        this.aPanel.setBorder(BorderFactory.createEtchedBorder());
        this.aPanel.setMaximumSize(new Dimension(14, 8));
        this.aPanel.setMinimumSize(new Dimension(14, 8));
        GroupLayout jPanel2Layout = new GroupLayout(this.aPanel);
        this.aPanel.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 172, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 8, Short.MAX_VALUE));
        this.VUMeter.add((Component)this.aPanel, "North");
        this.bPanel.setBackground(new Color(0, 0, 0));
        this.bPanel.setBorder(BorderFactory.createEtchedBorder());
        this.bPanel.setMaximumSize(new Dimension(14, 8));
        this.bPanel.setMinimumSize(new Dimension(14, 8));
        GroupLayout jPanel3Layout = new GroupLayout(this.bPanel);
        this.bPanel.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 172, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 8, Short.MAX_VALUE));
        this.VUMeter.add((Component)this.bPanel, "South");
        this.seperate.setSelected(true);
        this.seperate.setText("Sep.");
        this.seperate.setFocusable(false);
        this.seperate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WAVtoCPC.this.seperateActionPerformed(evt);
            }
        });
        this.jLabel19.setText("Sample Frequency");
        this.sfreq.setModel(new DefaultComboBoxModel<String>(new String[]{"16khz > 14khz", "12.000hz", "11.025hz", "8.000hz", "6000hz", "5513hz", "4000hz"}));
        this.sfreq.setFocusable(false);
        this.sfreq.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WAVtoCPC.this.sfreqActionPerformed(evt);
            }
        });
        this.filter.setText("Filter");
        this.filter.setFocusable(false);
        this.filter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WAVtoCPC.this.filterActionPerformed(evt);
            }
        });
        this.sendPlayCommand.setText("Send Play cmd.");
        this.sendPlayCommand.setFocusable(false);
        this.jLabel20.setIcon(new ImageIcon(this.getClass().getResource("logo.png")));
        this.jLabel20.setBorder(new SoftBevelBorder(0));
        this.jLabel20.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WAVtoCPC.this.jLabel20ActionPerformed(evt);
            }
        });
        this.jLabel20.setFocusable(false);
        this.mono.setText("Monosampling");
        this.mono.setFocusable(false);
        this.mono.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WAVtoCPC.this.monoActionPerformed(evt);
            }
        });
        this.to14.setSelected(true);
        this.to14.setText("16khz->14khz (Digiblaster can play 16khz, PSG only 14khz)");
        this.to14.setEnabled(false);
        this.to14.setFocusable(false);
        this.to14.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WAVtoCPC.this.to14ActionPerformed(evt);
            }
        });
        this.jLabel21.setText("Playback volume");
        this.volumeSet.setFocusable(false);
        this.volumeSet.setPreferredSize(new Dimension(150, 26));
        this.volumeSet.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                WAVtoCPC.this.volumeSetMouseReleased(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.mono).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.to14).addGap(18, 18, 18).addComponent(this.jLabel21).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.volumeSet, -2, 150, -2)).addGroup(layout.createSequentialGroup().addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.vol1, GroupLayout.Alignment.LEADING, -1, 38, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.vol2, -1, 38, Short.MAX_VALUE).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.vol3, -1, 38, Short.MAX_VALUE).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.vol4, -1, 38, Short.MAX_VALUE).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.vol5, -1, 38, Short.MAX_VALUE).addComponent(this.jLabel7, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.vol6, -1, 38, Short.MAX_VALUE).addComponent(this.jLabel8, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.vol7, -1, 38, Short.MAX_VALUE).addComponent(this.jLabel9, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.vol8, -1, 38, Short.MAX_VALUE).addComponent(this.jLabel10, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.vol9, -1, 38, Short.MAX_VALUE).addComponent(this.jLabel11, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.vol10, -1, 38, Short.MAX_VALUE).addComponent(this.jLabel12, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.vol11, -1, 38, Short.MAX_VALUE).addComponent(this.jLabel13, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.vol12, -1, 38, Short.MAX_VALUE).addComponent(this.jLabel14, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.vol13, -1, 38, Short.MAX_VALUE).addComponent(this.jLabel15, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.vol14, -1, 38, Short.MAX_VALUE).addComponent(this.jLabel16, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.vol15, -1, 38, Short.MAX_VALUE).addComponent(this.jLabel17, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.vol16, -1, 38, Short.MAX_VALUE).addComponent(this.jLabel18, -1, -1, Short.MAX_VALUE))).addComponent(this.jLabel1, -2, 696, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.normalize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.booster, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.seperate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel19).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sfreq).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.filter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sendPlayCommand))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.vol, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.asSample).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel20).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.VUMeter, -2, -1, -2))))))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButton1, GroupLayout.Alignment.LEADING, -1, 30, Short.MAX_VALUE).addComponent(this.normalize, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.booster, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel19).addComponent(this.sfreq, -2, -1, -2).addComponent(this.filter).addComponent(this.sendPlayCommand))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.vol, -2, -1, -2).addComponent(this.jCheckBox1).addComponent(this.seperate)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveButton).addComponent(this.asSample).addComponent(this.jCheckBox2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.VUMeter, -2, -1, -2).addComponent(this.jLabel20, -1, -1, Short.MAX_VALUE).addComponent(this.jButton3, -1, -1, Short.MAX_VALUE)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.to14, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel21)).addComponent(this.mono, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addComponent(this.volumeSet, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -2, 280, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.vol1, -2, -1, -2).addComponent(this.vol2, -2, -1, -2).addComponent(this.vol3, -2, -1, -2).addComponent(this.vol4, -2, -1, -2).addComponent(this.vol5, -2, -1, -2).addComponent(this.vol6, -2, -1, -2).addComponent(this.vol7, -2, -1, -2).addComponent(this.vol8, -2, -1, -2).addComponent(this.vol9, -2, -1, -2).addComponent(this.vol10, -2, -1, -2).addComponent(this.vol11, -2, -1, -2).addComponent(this.vol12, -2, -1, -2).addComponent(this.vol13, -2, -1, -2).addComponent(this.vol14, -2, -1, -2).addComponent(this.vol15, -2, -1, -2).addComponent(this.vol16, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3, -2, -1, -2).addComponent(this.jLabel4, -2, -1, -2).addComponent(this.jLabel5, -2, -1, -2).addComponent(this.jLabel6, -2, -1, -2).addComponent(this.jLabel7, -2, -1, -2).addComponent(this.jLabel8, -2, -1, -2).addComponent(this.jLabel9, -2, -1, -2).addComponent(this.jLabel10, -2, -1, -2).addComponent(this.jLabel11, -2, -1, -2).addComponent(this.jLabel12, -2, -1, -2).addComponent(this.jLabel13, -2, -1, -2).addComponent(this.jLabel14, -2, -1, -2).addComponent(this.jLabel15, -2, -1, -2).addComponent(this.jLabel16, -2, -1, -2).addComponent(this.jLabel17, -2, -1, -2).addComponent(this.jLabel18, -2, -1, -2)).addContainerGap()));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.Import();
    }

    private void normalizeActionPerformed(ActionEvent evt) {
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    private void vol1StateChanged(ChangeEvent evt) {
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    private void vol2StateChanged(ChangeEvent evt) {
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    private void vol4StateChanged(ChangeEvent evt) {
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    private void vol3StateChanged(ChangeEvent evt) {
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    private void vol8StateChanged(ChangeEvent evt) {
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    private void vol7StateChanged(ChangeEvent evt) {
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    private void vol6StateChanged(ChangeEvent evt) {
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    private void vol5StateChanged(ChangeEvent evt) {
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    private void vol9StateChanged(ChangeEvent evt) {
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    private void vol12StateChanged(ChangeEvent evt) {
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    private void vol11StateChanged(ChangeEvent evt) {
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    private void vol10StateChanged(ChangeEvent evt) {
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    private void vol15StateChanged(ChangeEvent evt) {
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    private void vol14StateChanged(ChangeEvent evt) {
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    private void vol13StateChanged(ChangeEvent evt) {
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    private void vol16StateChanged(ChangeEvent evt) {
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.inverted = this.jCheckBox1.isSelected();
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.Save();
    }

    private void asSampleActionPerformed(ActionEvent evt) {
        this.jCheckBox2.setEnabled(!this.asSample.isSelected());
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.newlinepos = 0;
        this.linepos = 0;
        this.Play();
    }

    private void seperateActionPerformed(ActionEvent evt) {
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    private void filterActionPerformed(ActionEvent evt) {
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    private void jLabel20ActionPerformed(ActionEvent evt) {
        this.moveSample();
    }

    private void monoActionPerformed(ActionEvent evt) {
        this.SAMPLE_RATE[0] = !this.mono.isSelected() ? 13600.0f : (this.to14.isSelected() ? 14000.0f : 16000.0f);
        this.to14.setEnabled(this.mono.isSelected());
        this.normalize.setEnabled(!this.mono.isSelected());
        this.booster.setEnabled(!this.mono.isSelected());
        this.seperate.setEnabled(!this.mono.isSelected());
        this.vol.setEnabled(!this.mono.isSelected());
        this.jCheckBox1.setEnabled(!this.mono.isSelected());
        this.filter.setEnabled(!this.mono.isSelected());
        this.newlinepos = this.pos;
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    private void to14ActionPerformed(ActionEvent evt) {
        this.SAMPLE_RATE[0] = this.mono.isSelected() ? (this.to14.isSelected() ? 14000.0f : 16000.0f) : 13600.0f;
        this.newlinepos = this.pos;
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    private void jLabel1MouseClicked(MouseEvent evt) {
        if (this.isMp3) {
            return;
        }
        if (evt.getButton() != 1) {
            boolean bl = this.displayinit = !this.displayinit;
        }
        if (evt.getClickCount() == 2 && this.left != null) {
            long isX = evt.getX();
            this.linepos = Math.toIntExact(isX * (long)this.left.length / 696L * (long)this.channels);
            this.newlinepos = 0;
            this.skipLine();
        }
    }

    private void volumeSetMouseReleased(MouseEvent evt) {
        if (this.isPlaying) {
            this.linepos = Math.toIntExact((long)this.line.getFramePosition() * (long)this.channels + (long)this.linepos);
            this.skipLine();
        }
    }

    private void boosterMouseReleased(MouseEvent evt) {
        if (!this.normalize.isSelected()) {
            return;
        }
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    private void sfreqActionPerformed(ActionEvent evt) {
        this.wasplaying = this.isPlaying;
        if (this.wasplaying) {
            this.isPlaying = false;
            this.line.stop();
            this.line.flush();
            this.line.drain();
            this.line.close();
        }
        this.linepos = 0;
        this.newlinepos = this.pos;
        this.initPlay();
        this.fillTable();
        if (!this.normalize.isSelected()) {
            // empty if block
        }
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    private void volActionPerformed(ActionEvent evt) {
        this.fillTable();
        if (this.filepath != null && this.filename != null) {
            this.Import(this.filepath, this.filename);
        }
    }

    public void Stop() {
        if (this.line.isActive() || this.export == null) {
            this.Play();
        }
    }

    public JInternalFrame getWavToCPC() {
        if (this.frame == null) {
            this.frame = new JInternalFrame();
            this.frame.addInternalFrameListener(new InternalFrameListener(){

                @Override
                public void internalFrameOpened(InternalFrameEvent ife) {
                }

                @Override
                public void internalFrameClosing(InternalFrameEvent ife) {
                    if (WAVtoCPC.this.line.isActive() || WAVtoCPC.this.export == null) {
                        WAVtoCPC.this.Play();
                    }
                }

                @Override
                public void internalFrameClosed(InternalFrameEvent ife) {
                }

                @Override
                public void internalFrameIconified(InternalFrameEvent ife) {
                }

                @Override
                public void internalFrameDeiconified(InternalFrameEvent ife) {
                }

                @Override
                public void internalFrameActivated(InternalFrameEvent ife) {
                }

                @Override
                public void internalFrameDeactivated(InternalFrameEvent ife) {
                }
            });
            this.frame.setMaximizable(false);
            this.frame.setTitle(this.getTitle());
            this.frame.setLayout(new BorderLayout());
            this.frame.add((Component)this, "Center");
            this.frame.pack();
            this.frame.setResizable(false);
            this.frame.setClosable(true);
            this.frame.setIconifiable(true);
            this.frame.setDefaultCloseOperation(1);
        }
        return this.frame;
    }

    public static void main(String[] args) {
        try {
            new SyntheticaLicense().register();
            UIManager.setLookAndFeel("de.javasoft.plaf.synthetica.SyntheticaBlackEyeLookAndFeel");
        }
        catch (Exception e) {
            try {
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    System.out.println(info.getName());
                    if (!info.getName().toLowerCase().contains("nimb")) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame fram = new JFrame();
                WAVtoCPC w = new WAVtoCPC(null);
                fram.setTitle(w.getTitle());
                fram.setLayout(new BorderLayout());
                fram.add((Component)w, "Center");
                fram.pack();
                fram.setVisible(true);
                fram.setDefaultCloseOperation(3);
                fram.setResizable(false);
            }
        });
    }
}

